package cn.com.duiba.cloud.biz.tool.aop.validation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * remote接口，对参数进行jsr-303校验<br>
 * <p>
 * feign无法开启jsr-303校验，因此只能通过aop实现。<br>
 * 适用于remote接口的参数校验，web应用还是直接使用jsr-303即可。<br>
 * 注解于remote接口的<b>实现类</b>上或实现类里对应的方法上。
 * </p>
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.4
 * @date 2021/12/13 5:54 下午
 * @since 0.0.4
 */
@Documented
@Target({ElementType.TYPE, ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
public @interface Validation {
}
