package cn.com.duiba.cloud.biz.tool.utils;

import cn.com.duiba.cloud.biz.tool.enums.IEnum;
import cn.com.duiba.wolf.utils.SwitchUtils;

import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

/**
 * 枚举工具类
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 1.0
 * @date 2021/11/24 4:27 下午
 * @since 0.0.1
 **/
public class EnumUtil {
    /**
     * 通过枚举值获取枚举对象
     *
     * @param enumClass 枚举类
     * @param dbCode    枚举值
     * @param <E>       枚举对象
     * @param <T>       枚举值数据类型
     *
     * @return 枚举对象
     */
    public static <E extends IEnum<T>, T> E getByCode(Class<E> enumClass, T dbCode) {
        return Stream.of(enumClass.getEnumConstants()).filter(v
                                                                      -> Objects.equals(v.getDbCode(), dbCode)).findFirst().orElse(null);
    }


    /**
     * 检查是否开关指定位上的开关
     *
     * @param bizSwitch 位数字
     * @param e         枚举，建议通过枚举来维护【位】对应的业务含义
     * @param <E>       推荐使用 Integer 类型枚举
     *
     * @return 是否打开，true-打开，false-关闭
     */
    public static <E extends IEnum<Integer>> boolean check(Integer bizSwitch, E e) {
        return SwitchUtils.switchIsOpen(bizSwitch, e.getDbCode());
    }

    /**
     * 打开或关闭指定位上的开关
     *
     * @param bizSwitch 位数字
     * @param e         枚举，建议通过枚举来维护【位】对应的业务含义
     * @param open      是否打开，null/false-关闭，true-打开
     * @param <E>       推荐使用 Integer 类型枚举
     *
     * @return 处理过后的位数字
     */
    public static <E extends IEnum<Integer>> Integer setSwitch(Integer bizSwitch, E e, Boolean open) {
        Integer dbCode = e.getDbCode();
        return Optional.ofNullable(open).orElse(Boolean.FALSE) ? SwitchUtils.openSwitch(bizSwitch, dbCode) : SwitchUtils.closeSwitch(bizSwitch, dbCode);
    }
}