/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.biz.tool.exception;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.biz.tool.message.BaseError;
import cn.com.duiba.wolf.entity.JsonResult;
import cn.hutool.core.io.IoUtil;
import cn.hutool.http.ContentType;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.lang.NonNull;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;

@Order(value=-2147483648)
public class WebMvcExceptionHandler
implements HandlerExceptionResolver {
    private static final Logger log = LoggerFactory.getLogger(WebMvcExceptionHandler.class);

    public ModelAndView resolveException(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, Object handler, @NonNull Exception e) {
        response.setContentType(ContentType.build((ContentType)ContentType.JSON, (Charset)StandardCharsets.UTF_8));
        try {
            if (e instanceof BizException) {
                return this.bizExceptionHandler(e, response);
            }
            if (e instanceof UndeclaredThrowableException) {
                if (e.getCause() instanceof BizException) {
                    return this.bizExceptionHandler((Exception)((BizException)e.getCause()), response);
                }
                return this.globalExceptionHandler(e, request, response);
            }
            if (e instanceof MethodArgumentNotValidException) {
                return this.methodArgumentNotValidExceptionHandler(e, response);
            }
            if (e instanceof IllegalArgumentException) {
                return this.illegalArgumentExceptionHandler(e, response);
            }
            return this.globalExceptionHandler(e, request, response);
        }
        catch (IOException ex) {
            throw new RuntimeException(e.getMessage(), ex);
        }
    }

    private ModelAndView bizExceptionHandler(Exception e, HttpServletResponse response) throws IOException {
        log.warn("BizException [{}]", (Object)e.getMessage(), (Object)e);
        this.ioWrite(response.getOutputStream(), JSON.toJSONString((Object)JsonResult.fail((String)((BizException)e).getCode(), (String)e.getMessage()), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        return new ModelAndView();
    }

    private ModelAndView methodArgumentNotValidExceptionHandler(Exception e, HttpServletResponse response) throws IOException {
        BindingResult bindResult = null;
        if (e instanceof BindException) {
            bindResult = ((BindException)e).getBindingResult();
        } else if (e instanceof MethodArgumentNotValidException) {
            bindResult = ((MethodArgumentNotValidException)e).getBindingResult();
        }
        String message = "\u53c2\u6570\u9519\u8bef";
        if (bindResult != null && bindResult.hasErrors()) {
            ObjectError objectError = (ObjectError)bindResult.getAllErrors().get(0);
            message = objectError.getDefaultMessage();
        }
        this.ioWrite(response.getOutputStream(), JSON.toJSONString((Object)JsonResult.fail((String)BaseError.PARAM_ERROR.getCode(), (String)message), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        return new ModelAndView();
    }

    private ModelAndView illegalArgumentExceptionHandler(Exception e, HttpServletResponse response) throws IOException {
        log.error("IllegalArgumentException", (Throwable)e);
        this.ioWrite(response.getOutputStream(), JSON.toJSONString((Object)JsonResult.fail((String)e.getMessage()), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        return new ModelAndView();
    }

    private ModelAndView globalExceptionHandler(Exception e, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String message = e.getMessage();
        if (e instanceof InvocationTargetException && message == null) {
            message = ((InvocationTargetException)e).getTargetException().getMessage();
        }
        log.error("Exception [{} -> {}]:", new Object[]{request.getRequestURI(), message, e});
        this.ioWrite(response.getOutputStream(), JSON.toJSONString((Object)JsonResult.fail((String)BaseError.SYSTEM_ERROR.getMsg()), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        return new ModelAndView();
    }

    private void ioWrite(ServletOutputStream outputStream, String msg) {
        IoUtil.writeUtf8((OutputStream)outputStream, (boolean)true, (Object[])new Object[]{msg});
    }
}

