package cn.com.duiba.cloud.biz.tool.message;

import lombok.Setter;

import java.util.Objects;

/**
 * 错误元对象
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 1.0
 * @date 2021/11/20 12:36 下午
 **/
@Setter
public class ErrorMeta implements Error<String> {
    private String code;
    private String desc;

    public ErrorMeta(String code, String desc) {
        super();
        Objects.requireNonNull(code, "code不能为null");
        Objects.requireNonNull(desc, "desc不能为null");
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String getDesc() {
        return desc;
    }

    @Override
    public String getCode() {
        return code;
    }
}