package cn.com.duiba.cloud.biz.tool.config.i18n;

import cn.com.duiba.cloud.biz.tool.constants.BaseConstant;
import cn.com.duiba.cloud.biz.tool.message.ErrorFactory;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.StrUtil;
import lombok.Data;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.util.List;

/**
 * 国际化资源文件列表
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2021/12/29 1:10 下午
 * @since 0.0.1
 **/
@Data
@ConfigurationProperties(prefix = "duiba.i18n.resource")
public class I18nProperties implements InitializingBean {
    /**
     * 国际化资源文件列表
     */
    private String list;

    @Override
    public void afterPropertiesSet() {
        List<String> i18nList;
        if (StrUtil.isEmpty(list)) {
            i18nList = ListUtil.list(false);
        } else {
            i18nList = ListUtil.toList(list.split(BaseConstant.SPLIT_COMMA));
        }
        ErrorFactory.initMessageSource(i18nList);
    }
}