package cn.com.duiba.cloud.biz.tool.utils;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.biz.tool.message.ErrorMeta;
import cn.com.duiba.cloud.biz.tool.message.MessageCallBack;

/**
 * bizException断言工具类
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.3
 * @date 2021/11/20 12:37 下午
 * @see BizException
 * @see ErrorMeta
 * @since 0.0.3
 **/
public class Conditions {
    /**
     * expression表达式为true，抛异常
     *
     * @param expression condition表达式
     * @param errorMeta  错误元对象
     * @throws BizException 业务异常
     */
    public static void expectFalse(boolean expression, ErrorMeta errorMeta) throws BizException {
        expectFalse(expression, errorMeta.getCode(), errorMeta.getMsg(), null);
    }

    /**
     * expression表达式为true，抛异常
     *
     * @param expression      condition表达式
     * @param errorMeta       错误元对象
     * @param messageCallBack 抛异常前回调方法
     * @throws BizException 业务异常
     */
    public static void expectFalse(boolean expression, ErrorMeta errorMeta, MessageCallBack messageCallBack) throws BizException {
        expectFalse(expression, errorMeta.getCode(), errorMeta.getMsg(), messageCallBack);
    }

    /**
     * expression表达式为true，抛异常
     *
     * @param expression condition表达式
     * @param desc       错误描述
     * @throws BizException 业务异常
     */
    public static void expectFalse(boolean expression, String desc) throws BizException {
        expectFalse(expression, null, desc, null);
    }

    /**
     * expression表达式为true，抛异常
     *
     * @param expression      condition表达式
     * @param desc            错误描述
     * @param messageCallBack 抛异常前回调方法
     * @throws BizException 业务异常
     */
    public static void expectFalse(boolean expression, String desc, MessageCallBack messageCallBack) throws BizException {
        expectFalse(expression, null, desc, messageCallBack);
    }

    /**
     * expression表达式为true，抛异常
     *
     * @param expression   condition表达式
     * @param bizException 业务异常
     * @throws BizException 业务异常
     */
    public static void expectFalse(boolean expression, BizException bizException) throws BizException {
        expectFalse(expression, bizException, null);
    }

    /**
     * expression表达式为true，抛异常
     *
     * @param expression      condition表达式
     * @param code            错误码
     * @param desc            错误描述
     * @param messageCallBack 抛异常前回调方法
     * @throws BizException 业务异常
     */
    public static void expectFalse(boolean expression, String code, String desc, MessageCallBack messageCallBack) throws BizException {
        if (expression) {
            if (null != messageCallBack) {
                messageCallBack.handle();
            }
            throw new BizException(desc).withCode(code);
        }
    }

    /**
     * expression表达式为true，抛异常
     *
     * @param expression      condition表达式
     * @param bizException    业务异常
     * @param messageCallBack 抛异常前回调方法
     * @throws BizException 业务异常
     */
    public static void expectFalse(boolean expression, BizException bizException, MessageCallBack messageCallBack) throws BizException {
        if (expression) {
            if (null != messageCallBack) {
                messageCallBack.handle();
            }
            throw bizException;
        }
    }

    /**
     * expression表达式只要有一个为false，抛异常
     *
     * @param errorMeta   错误元对象
     * @param expressions condition表达式
     * @throws BizException 业务异常
     */
    public static void expectAllTrue(ErrorMeta errorMeta, boolean... expressions) throws BizException {
        expectAllTrue(errorMeta.getCode(), errorMeta.getMsg(), null, expressions);
    }

    /**
     * expression表达式只要有一个为false，抛异常
     *
     * @param errorMeta       错误元对象
     * @param messageCallBack 抛异常前回调方法
     * @param expressions     condition表达式
     * @throws BizException 业务异常
     */
    public static void expectAllTrue(ErrorMeta errorMeta, MessageCallBack messageCallBack, boolean... expressions) throws BizException {
        expectAllTrue(errorMeta.getCode(), errorMeta.getMsg(), messageCallBack, expressions);
    }

    /**
     * expression表达式只要有一个为false，抛异常
     *
     * @param desc        错误描述
     * @param expressions condition表达式
     * @throws BizException 业务异常
     */
    public static void expectAllTrue(String desc, boolean... expressions) throws BizException {
        expectAllTrue(null, desc, null, expressions);
    }

    /**
     * expression表达式只要有一个为false，抛异常
     *
     * @param desc            错误描述
     * @param messageCallBack 抛异常前回调方法
     * @param expressions     condition表达式
     * @throws BizException 业务异常
     */
    public static void expectAllTrue(String desc, MessageCallBack messageCallBack, boolean... expressions) throws BizException {
        expectAllTrue(null, desc, messageCallBack, expressions);
    }

    /**
     * expression表达式只要有一个为false，抛异常
     *
     * @param code            错误码
     * @param desc            错误描述
     * @param messageCallBack 抛异常前回调方法
     * @param expressions     condition表达式
     * @throws BizException 业务异常
     */
    public static void expectAllTrue(String code, String desc, MessageCallBack messageCallBack, boolean... expressions) throws BizException {
        for (boolean b : expressions) {
            expectTrue(b, code, desc, messageCallBack);
        }
    }

    /**
     * expression表达式只要有一个为false，抛异常
     *
     * @param bizException    业务异常
     * @param messageCallBack 抛异常前回调方法
     * @param expressions     condition表达式
     * @throws BizException 业务异常
     */
    public static void expectAllTrue(BizException bizException, MessageCallBack messageCallBack, boolean... expressions) throws BizException {
        for (boolean b : expressions) {
            expectTrue(b, bizException, messageCallBack);
        }
    }

    /**
     * expression表达式为false，抛异常
     *
     * @param expression condition表达式
     * @param errorMeta  错误元对象
     * @throws BizException 业务异常
     */
    public static void expectTrue(boolean expression, ErrorMeta errorMeta) throws BizException {
        expectTrue(expression, errorMeta.getCode(), errorMeta.getMsg(), null);
    }

    /**
     * expression表达式为false，抛异常
     *
     * @param expression      condition表达式
     * @param errorMeta       错误元对象
     * @param messageCallBack 抛异常前回调方法
     * @throws BizException 业务异常
     */
    public static void expectTrue(boolean expression, ErrorMeta errorMeta, MessageCallBack messageCallBack) throws BizException {
        expectTrue(expression, errorMeta.getCode(), errorMeta.getMsg(), messageCallBack);
    }

    /**
     * expression表达式为false，抛异常
     *
     * @param expression condition表达式
     * @param desc       错误描述
     * @throws BizException 业务异常
     */
    public static void expectTrue(boolean expression, String desc) throws BizException {
        expectTrue(expression, null, desc, null);
    }

    /**
     * expression表达式为false，抛异常
     *
     * @param expression      condition表达式
     * @param desc            错误描述
     * @param messageCallBack 抛异常前回调方法
     * @throws BizException 业务异常
     */
    public static void expectTrue(boolean expression, String desc, MessageCallBack messageCallBack) throws BizException {
        expectTrue(expression, null, desc, messageCallBack);
    }

    /**
     * expression表达式为false，抛异常
     *
     * @param expression   condition表达式
     * @param bizException 业务异常
     * @throws BizException 业务异常
     */
    public static void expectTrue(boolean expression, BizException bizException) throws BizException {
        expectTrue(expression, bizException, null);
    }

    /**
     * expression表达式为false，抛异常
     *
     * @param expression      condition表达式
     * @param code            错误码
     * @param desc            错误描述
     * @param messageCallBack 抛异常前回调方法
     * @throws BizException 业务异常
     */
    public static void expectTrue(boolean expression, String code, String desc, MessageCallBack messageCallBack) throws BizException {
        if (!expression) {
            if (null != messageCallBack) {
                messageCallBack.handle();
            }
            throw new BizException(desc).withCode(code);
        }
    }

    /**
     * expression表达式为false，抛异常
     *
     * @param expression      condition表达式
     * @param bizException    业务异常
     * @param messageCallBack 抛异常前回调方法
     * @throws BizException 业务异常
     */
    public static void expectTrue(boolean expression, BizException bizException, MessageCallBack messageCallBack) throws BizException {
        if (!expression) {
            if (null != messageCallBack) {
                messageCallBack.handle();
            }
            throw bizException;
        }
    }

    public static <T> T expectNotNull(T reference, ErrorMeta errorMeta) throws BizException {
        return expectNotNull(reference, errorMeta.getCode(), errorMeta.getMsg(), null);
    }

    public static <T> T expectNotNull(T reference, ErrorMeta errorMeta, MessageCallBack messageCallBack) throws BizException {
        return expectNotNull(reference, errorMeta.getCode(), errorMeta.getMsg(), messageCallBack);
    }

    public static <T> T expectNotNull(T reference, String desc) throws BizException {
        return expectNotNull(reference, null, desc, null);
    }

    public static <T> T expectNotNull(T reference, String desc, MessageCallBack messageCallBack) throws BizException {
        return expectNotNull(reference, null, desc, messageCallBack);
    }

    public static <T> T expectNotNull(T reference, String code, String desc, MessageCallBack messageCallBack) throws BizException {
        if (reference == null) {
            if (null != messageCallBack) {
                messageCallBack.handle();
            }
            throw new BizException(desc).withCode(code);
        } else {
            return reference;
        }
    }

    public static <T> T expectNotNull(T reference, BizException bizException, MessageCallBack messageCallBack) throws BizException {
        if (reference == null) {
            if (null != messageCallBack) {
                messageCallBack.handle();
            }
            throw bizException;
        } else {
            return reference;
        }
    }
}