/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.biz.tool.exception;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.biz.tool.message.BaseError;
import cn.com.duiba.wolf.entity.JsonResult;
import java.lang.reflect.InvocationTargetException;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ExceptionHandler(value={BizException.class})
    public JsonResult<Void> bizExceptionHandler(BizException e) {
        log.warn("BizException [{}]", (Object)e.getMessage(), (Object)e);
        return JsonResult.fail((String)e.getCode(), (String)e.getMessage());
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class, BindException.class})
    public JsonResult<Void> methodArgumentNotValidExceptionHandler(Exception e) {
        BindingResult bindResult = null;
        if (e instanceof BindException) {
            bindResult = ((BindException)e).getBindingResult();
        } else if (e instanceof MethodArgumentNotValidException) {
            bindResult = ((MethodArgumentNotValidException)e).getBindingResult();
        }
        String message = "\u53c2\u6570\u9519\u8bef";
        if (bindResult != null && bindResult.hasErrors()) {
            ObjectError objectError = (ObjectError)bindResult.getAllErrors().get(0);
            message = objectError.getDefaultMessage();
        }
        return JsonResult.fail((String)BaseError.PARAM_ERROR.getCode(), (String)message);
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    public JsonResult<Void> illegalArgumentExceptionHandler(IllegalArgumentException e) {
        log.error("IllegalArgumentException", (Throwable)e);
        return JsonResult.fail((String)e.getMessage());
    }

    @ExceptionHandler(value={Exception.class})
    public JsonResult<Void> exceptionHandler(Exception e, HttpServletRequest request) {
        String message = e.getMessage();
        if (e instanceof InvocationTargetException && message == null) {
            message = ((InvocationTargetException)e).getTargetException().getMessage();
        }
        log.error("Exception [{} -> {}]:", new Object[]{request.getRequestURI(), message, e});
        return JsonResult.fail((String)BaseError.SYSTEM_ERROR.getMsg());
    }
}

