/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.biz.tool.utils;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.YamlPropertiesFactoryBean;
import org.springframework.core.env.Environment;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;

public class PropertiesUtil {
    private static final Logger log = LoggerFactory.getLogger(PropertiesUtil.class);
    public static final String[] DEFAULT_CONFIG_FILE = new String[]{"classpath:application.properties", "classpath:bootstrap.properties", "classpath:application.yml", "classpath:bootstrap.yml"};
    private final Set<String> configSet = CollUtil.newLinkedHashSet((Object[])new String[0]);
    private final Properties properties = new Properties();
    private static Environment environment;
    private static final ResourceLoader RESOURCE_LOADER;
    private static final ResourcePatternResolver RESOURCE_RESOLVER;
    private static final Pattern P_1;

    public PropertiesUtil(String ... configFiles) {
        for (String location : configFiles) {
            try {
                Resource resource = PropertiesUtil.getResource(location);
                if (!resource.exists()) continue;
                if (location.endsWith(".properties")) {
                    try {
                        InputStreamReader is = new InputStreamReader(resource.getInputStream(), StandardCharsets.UTF_8);
                        Object object = null;
                        try {
                            this.properties.load(is);
                            this.configSet.add(location);
                        }
                        catch (Throwable throwable) {
                            object = throwable;
                            throw throwable;
                        }
                        finally {
                            if (is != null) {
                                if (object != null) {
                                    try {
                                        is.close();
                                    }
                                    catch (Throwable throwable) {
                                        ((Throwable)object).addSuppressed(throwable);
                                    }
                                } else {
                                    is.close();
                                }
                            }
                        }
                    }
                    catch (IOException ex) {
                        log.error("Load " + location + " failure. ", (Throwable)ex);
                    }
                    continue;
                }
                if (!location.endsWith(".yml")) continue;
                YamlPropertiesFactoryBean bean = new YamlPropertiesFactoryBean();
                bean.setResources(new Resource[]{resource});
                for (Map.Entry entry : Objects.requireNonNull(bean.getObject()).entrySet()) {
                    this.properties.put(ObjectUtil.toString(entry.getKey()), ObjectUtil.toString(entry.getValue()));
                }
                this.configSet.add(location);
            }
            catch (Exception e) {
                log.error("Load " + location + " failure. ", (Throwable)e);
            }
        }
    }

    public static PropertiesUtil getInstance() {
        return PropertiesLoaderHolder.INSTANCE;
    }

    public static void reloadInstance() {
        PropertiesLoaderHolder.reloadInstance();
    }

    public String getProperty(String key) {
        String value;
        if (environment != null && (value = environment.getProperty(key)) != null) {
            return value;
        }
        value = this.properties.getProperty(key);
        if (value != null) {
            Matcher m = P_1.matcher(value);
            while (m.find()) {
                String g = m.group();
                String childKey = g.replaceAll("\\$\\{|}", "");
                value = StrUtil.replace((CharSequence)value, (CharSequence)g, (CharSequence)this.getProperty(childKey));
            }
            return value;
        }
        return System.getProperty(key);
    }

    public String getProperty(String key, String defaultValue) {
        String value = this.getProperty(key);
        return value != null ? value : defaultValue;
    }

    public static void setEnvironment(Environment environment) {
        PropertiesUtil.environment = environment;
    }

    private static String substringBeforeLast(String str, String separator) {
        if (!StrUtil.isEmpty((CharSequence)str) && !StrUtil.isEmpty((CharSequence)separator)) {
            int pos = str.lastIndexOf(separator);
            return pos == -1 ? str : str.substring(0, pos);
        }
        return str;
    }

    private static Resource[] getResources(String locationPattern) {
        try {
            return RESOURCE_RESOLVER.getResources(locationPattern);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static Resource getResource(String location) {
        return RESOURCE_LOADER.getResource(location);
    }

    public Set<String> getConfigSet() {
        return this.configSet;
    }

    public Properties getProperties() {
        return this.properties;
    }

    static {
        RESOURCE_LOADER = new DefaultResourceLoader();
        RESOURCE_RESOLVER = new PathMatchingResourcePatternResolver(RESOURCE_LOADER);
        P_1 = Pattern.compile("\\$\\{.*?}");
    }

    private static final class PropertiesLoaderHolder {
        private static PropertiesUtil INSTANCE;

        private PropertiesLoaderHolder() {
        }

        public static void reloadInstance() {
            Resource[] resources;
            LinkedHashSet configSet = CollUtil.newLinkedHashSet((Object[])new String[0]);
            for (Resource resource : resources = PropertiesUtil.getResources("classpath*:/config/module-*.*")) {
                configSet.add("classpath:config/" + resource.getFilename());
            }
            LinkedHashSet set = CollUtil.newLinkedHashSet((Object[])new String[0]);
            Collections.addAll(set, DEFAULT_CONFIG_FILE);
            String customConfigs = System.getProperty("spring.config.location");
            if (StrUtil.isNotBlank((CharSequence)customConfigs)) {
                for (String customConfig : StrUtil.split((CharSequence)customConfigs, (CharSequence)",")) {
                    if (!customConfig.contains("$") && !ResourceUtils.isUrl((String)(customConfig = StringUtils.cleanPath((String)customConfig)))) {
                        customConfig = "file:" + customConfig;
                    }
                    set.add(customConfig);
                }
            }
            String[] configFiles = set.toArray(new String[0]);
            String profiles = System.getProperty("spring.profiles.active");
            if (StrUtil.isBlank((CharSequence)profiles)) {
                PropertiesUtil propsTemp = new PropertiesUtil(configFiles);
                profiles = propsTemp.getProperty("spring.profiles.active");
            }
            for (String location : configFiles) {
                configSet.add(location);
                if (!StrUtil.isNotBlank((CharSequence)profiles)) continue;
                if (location.endsWith(".properties")) {
                    configSet.add(PropertiesUtil.substringBeforeLast(location, ".properties") + "-" + profiles + ".properties");
                    continue;
                }
                if (!location.endsWith(".yml")) continue;
                configSet.add(PropertiesUtil.substringBeforeLast(location, ".yml") + "-" + profiles + ".yml");
            }
            configFiles = configSet.toArray(new String[0]);
            log.debug("Loading module config: {}", (Object)configFiles);
            INSTANCE = new PropertiesUtil(configFiles);
        }

        static {
            PropertiesLoaderHolder.reloadInstance();
        }
    }
}

