package cn.com.duiba.cloud.channel.center.api.param.sale;

import cn.com.duiba.wolf.entity.PageRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 分页查询sku列表请求参数
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2022/1/4 3:23 下午
 * @since 0.0.1
 **/
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
public class PageSkuParam extends PageRequest implements Serializable {
    private static final long serialVersionUID = 5626260601419137877L;

    /**
     * spuId
     */
    @NotNull(message = "spuId不能为空")
    private Long spuId;

    /**
     * skuId
     */
    private Long skuId;

    /**
     * sku名称
     */
    private String skuName;

    /**
     * 应用ID
     */
    @NotNull(message = "应用id不能为空")
    private Long appId;

    /**
     * 分页查询时，是否需要查询总数<br>
     * 默认false，不查询
     */
    private Boolean isSearchCount = false;
}