package cn.com.duiba.cloud.channel.center.api.param.sale;

import cn.com.duiba.cloud.channel.center.api.constant.sale.SpuAuditStatusEnum;
import cn.com.duiba.cloud.channel.center.api.param.CurTenantParam;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotNull;

/**
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2022/1/4 15:52
 */
@Setter
@Getter
public class SpuAuditAuditParam extends CurTenantParam {
    private static final long serialVersionUID = 1L;

    @NotNull(message = "审批单Id不能为空")
    private Long spuAuditId;

    /**
     * @see SpuAuditStatusEnum
     */
    @NotNull(message = "审批状态不能为空")
    private Integer auditStatus;

    /**
     * 审核备注
     */
    private String auditReason = "";

    private Boolean needUpdateSpuLastAuditStatus = true;

    @NotNull(message = "appId不能为空")
    private Long appId;
    @NotNull(message = "商品Id不能为空")
    private Long spuId;
}
