package cn.com.duiba.cloud.channel.center.api.param.sale;

import cn.com.duiba.cloud.channel.center.api.constant.sale.SpuAuditStatusEnum;
import cn.com.duiba.cloud.channel.center.api.constant.sale.SpuAuditTypeEnum;
import cn.com.duiba.cloud.channel.center.api.param.CurTenantParam;
import lombok.Getter;
import lombok.Setter;

import java.util.Date;
import java.util.List;

/**
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2022/1/4 15:51
 */
@Setter
@Getter
public class SpuAuditQueryParam extends CurTenantParam {
    private static final long serialVersionUID = 1L;

    private Long spuAuditId;
    private String spuName;
    private Long spuId;
    /**
     * 审批类型
     *
     * @see SpuAuditTypeEnum
     */
    private Integer auditType;

    /**
     * 审核单状态
     *
     * @see SpuAuditStatusEnum
     */
    private Integer auditStatus;

    /**
     * 提交审核时间
     */
    private Date createSt;
    private Date createEd;

    /**
     * 用户id/租户Id/货主Id
     */
    private List<Long> appIdList;

    /**
     * 两个大字段做成了可选
     */
    private Boolean needAuditContent = true;
    private Boolean needAuditBeforeContent = true;

}
