package cn.com.duiba.cloud.channel.center.api.constant.sale;

import cn.com.duiba.cloud.biz.tool.enums.IEnum;

/**
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2022/1/4 12:06
 */
@SuppressWarnings("AlibabaEnumConstantsMustHaveComment")
public enum SpuAuditStatusEnum implements IEnum<Integer> {
    /**
     * 注意该状态不落库
     */
    NULL(-1, "未发起审核"),
    WAIT(0, "待审核"),
    CANCEL(1, "已取消"),
    PASS(50, "审核通过"),
    REJECT(99, "审核拒绝"),
    ;

    private final Integer auditStatus;
    private final String desc;

    SpuAuditStatusEnum(Integer shelfStatus, String desc) {
        this.auditStatus = shelfStatus;
        this.desc = desc;
    }

    public Integer getAuditStatus() {
        return auditStatus;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * 获取code
     *
     * @return value()
     */
    @Override
    public Integer getDbCode() {
        return getAuditStatus();
    }
}
