package cn.com.duiba.cloud.channel.center.api.param.sale;

import cn.com.duiba.wolf.entity.PageRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 兑吧分页查询spu列表请求参数
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2022/1/4 3:23 下午
 * @since 0.0.1
 **/
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
public class DuibaPageSpuParam extends PageRequest implements Serializable {
    private static final long serialVersionUID = 5626260601419137877L;

    /**
     * spuId
     */
    private Long spuId;

    /**
     * 兑吧的应用id
     */
    @NotNull(message = "应用id不能为空")
    private Long appId;

    /**
     * 供应商应用id列表
     */
    private List<Long> sourceAppIdList;

    /**
     * 商品类型
     */
    private Integer spuType;

    /**
     * 类目id
     */
    private Long categoryId;

    /**
     * 商品名称
     */
    private String spuName;

    /**
     * 上架状态(0:未上架/仓库中,1:已上架/供货中)
     */
    private Integer shelfStatus;

    /**
     * 选品开始时间
     */
    private Date beginTime;

    /**
     * 选品结束时间
     */
    private Date endTime;

    /**
     * 选品列表筛选条件，是否已选商品
     */
    private Integer isSelect;

    /**
     * 分页查询时，是否需要查询总数<br>
     * 默认false，不查询
     */
    private Boolean isSearchCount = false;
}