package cn.com.duiba.cloud.channel.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.channel.center.api.dto.sale.DuibaSkuSaleDTO;
import cn.com.duiba.cloud.channel.center.api.dto.sale.DuibaSpuSaleDTO;
import cn.com.duiba.cloud.channel.center.api.dto.sale.SkuSaleDTO;
import cn.com.duiba.cloud.channel.center.api.dto.sale.SupplierSpuSaleDTO;
import cn.com.duiba.cloud.channel.center.api.dto.sale.TenantSpuSaleDTO;
import cn.com.duiba.cloud.channel.center.api.exception.Error;
import cn.com.duiba.cloud.channel.center.api.param.sale.DuibaPageSpuParam;
import cn.com.duiba.cloud.channel.center.api.param.sale.GetSkuIdListParam;
import cn.com.duiba.cloud.channel.center.api.param.sale.PageSkuParam;
import cn.com.duiba.cloud.channel.center.api.param.sale.SupplierPageSpuParam;
import cn.com.duiba.cloud.channel.center.api.param.sale.TenantPageSpuParam;
import cn.com.duiba.wolf.entity.PageResponse;

import java.util.List;

/**
 * 上架项remote
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2022/1/4 3:44 下午
 * @since 0.0.1
 **/
@AdvancedFeignClient
public interface RemoteSaleService {
    /**
     * 供应商分页查询spu列表
     *
     * @param supplierPageSpuParam 供应商分页查询spu请求参数
     * @return spu列表
     * @throws BizException 业务异常 {@link Error}
     */
    PageResponse<SupplierSpuSaleDTO> pageSupplierSpu(SupplierPageSpuParam supplierPageSpuParam) throws BizException;

    /**
     * 兑吧分页查询spu列表
     *
     * @param duibaPageSpuParam 兑吧分页查询spu列表请求参数
     * @return spu列表
     * @throws BizException 业务异常 {@link Error}
     */
    PageResponse<DuibaSpuSaleDTO> pageDuibaSpu(DuibaPageSpuParam duibaPageSpuParam) throws BizException;

    /**
     * 租户分页查询spu列表
     *
     * @param tenantPageSpuParam 租户分页查询spu列表请求参数
     * @return spu列表
     * @throws BizException 业务异常 {@link Error}
     */
    PageResponse<TenantSpuSaleDTO> pageTenantSpu(TenantPageSpuParam tenantPageSpuParam) throws BizException;

    /**
     * 分页查询sku列表
     *
     * @param pageSkuParam 分页查询sku列表请求参数
     * @return sku列表
     * @throws BizException 业务异常 {@link Error}
     */
    PageResponse<SkuSaleDTO> pageSkuSale(PageSkuParam pageSkuParam) throws BizException;

    /**
     * 兑吧分页查询sku列表
     *
     * @param pageSkuParam 兑吧分页查询sku列表请求参数
     * @return sku列表
     * @throws BizException 业务异常 {@link Error}
     */
    PageResponse<DuibaSkuSaleDTO> pageDuibaSkuSale(PageSkuParam pageSkuParam) throws BizException;

    /**
     * 根据spuId获取skuId列表
     *
     * @param getSkuIdListParam 根据spuId获取skuId列表请求参数
     * @return skuId列表
     */
    List<Long> getSkuIdListBySpuId(GetSkuIdListParam getSkuIdListParam);
}