package cn.com.duiba.cloud.channel.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.channel.center.api.dto.sale.SpuAuditDTO;
import cn.com.duiba.cloud.channel.center.api.param.sale.SpuAuditAuditParam;
import cn.com.duiba.cloud.channel.center.api.param.sale.SpuAuditQueryParam;
import cn.com.duiba.cloud.channel.center.api.param.sale.SpuAuditSaveParam;
import cn.com.duiba.wolf.entity.PageResponse;

import javax.validation.Valid;
import java.util.List;

/**
 * 商品审核服务
 *
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2022/1/4 15:37
 */
@AdvancedFeignClient
@SuppressWarnings("unused")
public interface RemoteSpuAuditService {

    /**
     * 列表查询
     */
    PageResponse<SpuAuditDTO> list(SpuAuditQueryParam queryParam) throws BizException;

    /**
     * 保存审核
     * 会更新spu最后一次审核状态
     * 会取消待审批的审批单
     */
    Boolean save(SpuAuditSaveParam saveParam) throws BizException;

    /**
     * 进行审核
     * 会更新spu最后一次审核状态
     */
    Boolean audit(@Valid SpuAuditAuditParam auditParam) throws BizException;

    /**
     * 查询spu对应的最新的审批单
     *
     * @param spuIds
     *
     * @return
     * @throws BizException
     */
    List<SpuAuditDTO> findLatestWaitAuditIdBySpuIds(List<Long> spuIds) throws BizException;
}
