package cn.com.duiba.cloud.channel.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.channel.center.api.dto.sale.SaleDTO;
import cn.com.duiba.cloud.channel.center.api.param.sale.SaleDetailParam;
import cn.com.duiba.cloud.channel.center.api.param.sale.SaleSaveParam;
import cn.com.duiba.cloud.channel.center.api.param.sale.SaleShelfParam;
import cn.com.duiba.cloud.channel.center.api.param.sale.SaleSpuInfoUpdateParam;

/**
 * 商品渠道服务
 *
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2022/1/4 15:37
 */
@AdvancedFeignClient
@SuppressWarnings("unused")
public interface RemoteSpuChannelService {

    /**
     * 保存渠道相关信息，是一个事务
     *
     * @param param
     *
     * @return
     * @throws BizException
     */
    Boolean saveSale(SaleSaveParam param) throws BizException;


    /**
     * 获取渠道信息
     *
     * @param param
     *
     * @return
     * @throws BizException
     */
    SaleDTO getBySpuIdAndAppId(SaleDetailParam param) throws BizException;


    /**
     * 通过spuId来更新Spu信息信息
     *
     * @param updateParam
     *
     * @return
     * @throws BizException
     */
    int updateSpuInfoBySpuId(SaleSpuInfoUpdateParam updateParam) throws BizException;


    /**
     * 商品上下架
     *
     * @param shelfParam
     *
     * @return
     * @throws BizException
     */
    Boolean changeShelfStatus(SaleShelfParam shelfParam) throws BizException;
}
