package cn.com.duiba.cloud.channel.center.api.param.sale;

import cn.com.duiba.cloud.channel.center.api.constant.sale.ShelfStatusEnum;
import cn.com.duiba.cloud.channel.center.api.param.CurTenantParam;
import lombok.Getter;
import lombok.Setter;

/**
 * 选品参数
 *
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2022/1/12 14:49
 */
@Setter
@Getter
public class SaleCopyParam extends CurTenantParam {
    private static final long serialVersionUID = 1L;
    private Long spuId;
    private Long appId;

    /**
     * 选品的上架状态，默认为下架
     * 1-上架  0-下架
     *
     * @see ShelfStatusEnum
     */
    private Integer shelfStatus = ShelfStatusEnum.SHELVE.getShelfStatus();

    /**
     * 供货价是否等于供应商给的供货价
     */
    private Boolean supplyPriceIsCostPrice = Boolean.TRUE;
}
