package cn.com.duiba.cloud.channel.center.api.param.sale;

import cn.com.duiba.cloud.channel.center.api.constant.sale.ShelfStatusEnum;
import cn.com.duiba.cloud.channel.center.api.param.CurTenantParam;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 商品上下架参数
 *
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2022/1/10 13:49
 */
@Setter
@Getter
public class SaleShelfParam extends CurTenantParam {
    private static final long serialVersionUID = 1L;
    /**
     * 商品Id
     */
    @NotBlank(message = "商品Id不能为空")
    private Long spuId;

    /**
     * 没有就说明是整个 spu 下所有 sku 都下架
     */
    private Long skuId;

    /**
     * 1-上架  0-下架
     *
     * @see ShelfStatusEnum
     */
    @NotNull(message = "上架状态不能为空")
    private Integer shelfStatus;

    /**
     * 下游appId集合，正常只有一个
     */
    private Long destAppId;


    /**
     * 是否要更新spu的上架状态（兑吧用）
     */
    private Boolean needUpdateSpuShelfStatus = false;
}
