package cn.com.duiba.cloud.channel.center.api.dto.sale;

import cn.com.duiba.cloud.channel.center.api.constant.sale.ShelfStatusEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * sku上架项DTO
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2022/1/4 3:14 下午
 * @since 0.0.1
 **/
@Data
public class SkuSaleDTO implements Serializable {
    private static final long serialVersionUID = -2101769571491983947L;

    /**
     * sku上架项id
     */
    private Long skuSaleId;

    /**
     * skuId
     */
    private Long skuId;

    /**
     * spuId
     */
    private Long spuId;

    /**
     * sku名称
     */
    private String skuName;

    /**
     * spu名称
     */
    private String spuName;

    /**
     * 供货价
     */
    private Long supplyPrice;

    /**
     * 划线价
     */
    private Long facePrice;

    /**
     * 成本价
     */
    private Long costPrice;

    /**
     * 应用id
     */
    private Long appId;

    /**
     * 税率
     */
    private Short taxRate;

    /**
     * 上架状态(0:未上架,1:已上架)
     *
     * @see ShelfStatusEnum
     */
    private Integer shelfStatus;

    /**
     * 来源应用id
     */
    private Long sourceAppId;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 属性key，后端用，用于分辨sku
     */
    private String attributeKey;
}