package cn.com.duiba.cloud.channel.center.api.constant.sale;

import cn.com.duiba.cloud.biz.tool.enums.IEnum;
import cn.com.duiba.wolf.utils.SwitchUtils;
import lombok.Getter;

/**
 * 描述：
 *
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2022/4/6 18:11
 */
@Getter
public enum ExchangeSwitchEnum implements IEnum<Integer> {
    ORDER_AUDIT(0, "是否开启订单审核"),
    STOCK_WARN(1, "是否开启库存预警"),
    ;


    private final Integer exchangeSwitch;
    private final String desc;

    ExchangeSwitchEnum(Integer exchangeSwitch, String desc) {
        this.exchangeSwitch = exchangeSwitch;
        this.desc = desc;
    }


    @Override
    public Integer getDbCode() {
        return getExchangeSwitch();
    }


    /**
     * 检查是否开关
     */
    public static boolean check(Integer exchangeSwitch, ExchangeSwitchEnum switchEnum) {
        return SwitchUtils.switchIsOpen(exchangeSwitch, switchEnum.getExchangeSwitch());
    }

    /**
     * 打开
     */
    public static Integer open(Integer exchangeSwitch, ExchangeSwitchEnum switchEnum) {
        return SwitchUtils.openSwitch(exchangeSwitch, switchEnum.getExchangeSwitch());
    }

    /**
     * 关闭
     */
    public static Integer close(Integer exchangeSwitch, ExchangeSwitchEnum switchEnum) {
        return SwitchUtils.closeSwitch(exchangeSwitch, switchEnum.getExchangeSwitch());
    }
}
