package cn.com.duiba.cloud.channel.center.api.param.sale;

import cn.com.duiba.cloud.channel.center.api.constant.sale.ShelfStatusEnum;
import cn.com.duiba.cloud.channel.center.api.param.BaseAppParam;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.List;

/**
 * 批量根据spuId获取skuId列表请求参数
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @since 0.0.5
 **/
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
public class RemoteBatchGetSkuIdListParam extends BaseAppParam implements Serializable {
    private static final long serialVersionUID = -818763015390930897L;

    /**
     * spuId列表
     */
    @NotNull(message = "spuId列表不能为空")
    @Size(min = 1, max = 50, message = "spuId列表长度必须在1-50")
    private List<Long> spuIdList;

    /**
     * 上架状态
     *
     * @see ShelfStatusEnum
     */
    private Integer shelfStatus;
}