package cn.com.duiba.cloud.channel.center.api.param.sale;

import cn.com.duiba.cloud.channel.center.api.constant.sale.ShelfStatusEnum;
import cn.com.duiba.cloud.channel.center.api.param.CurTenantParam;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 商品上下架参数
 *
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2022/1/10 13:49
 */
@Setter
@Getter
public class SaleShelfParam extends CurTenantParam {
    private static final long serialVersionUID = 1L;
    /**
     * 商品Id
     */
    @NotBlank(message = "商品Id不能为空")
    private Long spuId;

    /**
     * 有就说明是指定sku
     */
    private Long skuId;

    /**
     * 1-上架  0-下架
     *
     * @see ShelfStatusEnum
     */
    @NotNull(message = "上架状态不能为空")
    private Integer shelfStatus;


    /**
     * 更改类型
     * 1-供应商 2-兑吧 3-积分商城
     */
    @NotNull
    private Integer type;
}
