package cn.com.duiba.cloud.channel.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.channel.center.api.dto.sale.SkuChannelConfigDto;
import cn.com.duiba.cloud.channel.center.api.dto.sale.SpuChannelConfigDto;
import cn.com.duiba.cloud.channel.center.api.param.sale.ShelfChannelQueryParam;
import cn.com.duiba.cloud.channel.center.api.param.sale.SkuChannelConfigSaveParam;
import cn.com.duiba.cloud.channel.center.api.param.sale.SpuShelfOperateParam;
import cn.com.duiba.wolf.entity.PageResponse;

/**
 * 描述：定向渠道相关
 *
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2022/4/2 14:02
 */
@AdvancedFeignClient
public interface RemoteShelfChannelService {

    /**
     * 修改定向分配类型（Spu 维度）
     *
     * @param param
     *
     * @return
     * @throws BizException
     */
    Boolean changeShelfTye(SpuShelfOperateParam param) throws BizException;


    /**
     * 添加定向渠道（Spu 维度）
     *
     * @param param
     *
     * @return
     * @throws BizException
     */
    Boolean addShelfChannel(SpuShelfOperateParam param) throws BizException;


    /**
     * 删除定向渠道（Spu 维度）
     *
     * @param param
     *
     * @return
     * @throws BizException
     */
    Boolean removeShelfChannel(SpuShelfOperateParam param) throws BizException;


    /**
     * 统计渠道数量（Spu 维度）
     *
     * @param param
     *
     * @return
     * @throws BizException
     */
    Long countBySpu(ShelfChannelQueryParam param) throws BizException;

    /**
     * spu 渠道列表
     *
     * @param param
     *
     * @return
     * @throws BizException
     */
    PageResponse<SpuChannelConfigDto> pageBySpu(ShelfChannelQueryParam param) throws BizException;


    /**
     * sku 渠道列表
     *
     * @param param
     *
     * @return
     * @throws BizException
     */
    PageResponse<SkuChannelConfigDto> pageBySku(ShelfChannelQueryParam param) throws BizException;


    /**
     * 分配渠道库存（Sku 维度）
     *
     * @param param
     *
     * @return
     * @throws BizException
     */
    Boolean editSkuChannelConfig(SkuChannelConfigSaveParam param) throws BizException;

}
