package cn.com.duiba.cloud.channel.center.api.constant.sale;

import cn.com.duiba.cloud.biz.tool.enums.IEnum;

/**
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2022/1/4 13:14
 */
@SuppressWarnings("AlibabaEnumConstantsMustHaveComment")
public enum AddrLimitTypeEnum implements IEnum<Integer> {
    WHITE(1, "白名单"),
    BLACK(2, "黑名单"),
    ;

    private final Integer limitType;
    private final String desc;

    AddrLimitTypeEnum(Integer shelfStatus, String desc) {
        this.limitType = shelfStatus;
        this.desc = desc;
    }

    public Integer getLimitType() {
        return limitType;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * 获取code
     *
     * @return value()
     */
    @Override
    public Integer getDbCode() {
        return getLimitType();
    }
}