package cn.com.duiba.cloud.channel.center.api.dto.sale;

import cn.com.duiba.cloud.channel.center.api.constant.sale.ExchangeSwitchEnum;
import cn.com.duiba.cloud.channel.center.api.constant.sale.ShelfStatusEnum;
import cn.com.duiba.cloud.channel.center.api.constant.sale.ShelfTypeEnum;
import cn.com.duiba.cloud.channel.center.api.constant.sale.SourceTypeEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

/**
 * 通用spu上架项DTO
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2022/1/7 2:45 下午
 * @since 0.0.1
 **/
@Data
public class BaseSpuSaleDTO implements Serializable {
    private static final long serialVersionUID = -4830926669754960482L;

    /**
     * spu上架项id
     */
    private Long spuSaleId;

    /**
     * spuId
     */
    private Long spuId;

    /**
     * 商品名称
     */
    private String spuName;

    /**
     * 商品类型(1:实物,2:优惠券,3:充值,4:权益)
     */
    private Integer spuType;

    /**
     * 商品类目id
     */
    private Long categoryId;

    /**
     * 应用id
     */
    private Long appId;

    /**
     * 来源应用id
     */
    private Long sourceAppId;

    /**
     * 最新一次审核单的状态(-1:未提交,0:待审核,1:已取消,50:审核通过,99:审核拒绝)
     */
    private Integer lastAuditStatus;

    /**
     * 最低供货价
     */
    private Long supplyPriceMin;

    /**
     * 最高供货价
     */
    private Long supplyPriceMax;

    /**
     * 最低划线价
     */
    private Long facePriceMin;

    /**
     * 最高划线价
     */
    private Long facePriceMax;

    /**
     * 最低成本价
     */
    private Long costPriceMin;

    /**
     * 最高成本价
     */
    private Long costPriceMax;

    /**
     * 上架状态(0:未上架/仓库中,1:已上架/供货中,3:部分上架)
     *
     * @see ShelfStatusEnum
     */
    private Integer shelfStatus;

    /**
     * 保存时设置的上架状态(0-未上架/仓库中,1-已上架/供货中)
     */
    private Integer shelfSwitch;

    /**
     * 是否可用
     */
    private Integer isUsable;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;


    /**
     * 商品来源类型
     *
     * @see SourceTypeEnum
     */
    private Integer sourceType;
    /**
     * 上架类型
     *
     * @see ShelfTypeEnum
     */
    private Integer shelfType;
    /**
     * 8 位开关
     *
     * @see ExchangeSwitchEnum
     */
    private Integer exchangeSwitch;


    /**
     * 已上架的最低供货价
     */
    private Long shelfSupplyPriceMin;

    /**
     * 已上架的最高供货价
     */
    private Long shelfSupplyPriceMax;


    public boolean selfGoods() {
        return Objects.equals(this.getAppId(), this.getSourceAppId());
    }
}