package cn.com.duiba.cloud.channel.center.api.dto.sale;

import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * 商品渠道包装类
 *
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2022/1/6 10:34
 */
@Setter
@Getter
public class SaleDTO implements Serializable {
    private static final long serialVersionUID = 1L;

    @NotNull(message = "商品编码不能为空")
    private Long spuId;

    private BaseSpuSaleDTO spuSaleDTO;
    private List<SkuSaleDTO> skuSaleDTOList;
    private List<AddrLimitDTO> addrLimitDTOList;
    private SpuExpressDTO spuExpressDTO;

    private SpuDescConfigDto spuDescConfigDto;

    public SaleDTO() {
    }

    public SaleDTO(Long spuId, BaseSpuSaleDTO spuSaleDTO,
                   List<SkuSaleDTO> skuSaleDTOList,
                   SpuExpressDTO spuExpressDTO,
                   List<AddrLimitDTO> addrLimitDTOList) {
        this.spuId = spuId;
        this.spuSaleDTO = spuSaleDTO;
        this.skuSaleDTOList = skuSaleDTOList;
        this.spuExpressDTO = spuExpressDTO;
        this.addrLimitDTOList = addrLimitDTOList;
    }

    public SaleDTO(Long spuId,
                   BaseSpuSaleDTO spuSaleDTO,
                   List<SkuSaleDTO> skuSaleDTOList,
                   List<AddrLimitDTO> addrLimitDTOList,
                   SpuExpressDTO spuExpressDTO,
                   SpuDescConfigDto spuDescConfigDto) {
        this(spuId, spuSaleDTO, skuSaleDTOList, spuExpressDTO, addrLimitDTOList);
        this.spuDescConfigDto = spuDescConfigDto;
    }
}
