package cn.com.duiba.cloud.channel.center.api.param.sale;

import cn.com.duiba.wolf.entity.PageRequest;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2022/1/13 17:00
 */
@Setter
@Getter
public class PageSkuBatchParam extends PageRequest implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 分页查询时，是否需要查询总数<br>
     * 默认false，不查询
     */
    private Boolean isSearchCount = false;

    /**
     * 批量查询，分appId
     * 设置了该属性其他属性都会不去查询
     */
    private List<PageSkuBatchParam.Item> list = new ArrayList<>();

    @Setter
    @Getter
    public static class Item implements Serializable {
        private static final long serialVersionUID = 1L;

        @NotNull(message = "供应商编码不允许为空")
        private Long appId;
        private Long spuId;
        private Long skuId;

        public Item() {
        }

        public Item(Long appId, Long spuId, Long skuId) {
            this.appId = appId;
            this.spuId = spuId;
            this.skuId = skuId;
        }
    }


}
