package cn.com.duiba.cloud.channel.center.api.param.sale;

import cn.com.duiba.cloud.channel.center.api.constant.sale.ExchangeSwitchEnum;
import cn.com.duiba.cloud.channel.center.api.constant.sale.ShelfStatusEnum;
import cn.com.duiba.cloud.channel.center.api.constant.sale.ShelfTypeEnum;
import cn.com.duiba.cloud.channel.center.api.constant.sale.SourceTypeEnum;
import cn.com.duiba.cloud.channel.center.api.param.CurTenantParam;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotNull;

/**
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2022/1/9 16:20
 */
@Setter
@Getter
public class SaleSpuInfoUpdateParam extends CurTenantParam {
    private static final long serialVersionUID = 1L;

    @NotNull
    private Long spuId;

    private Long appId;

    /**
     * 商品名称
     */
    private String spuName;

    /**
     * 商品类型(1:实物,2:优惠券,3:充值,4:权益)
     */
    private Integer spuType;

    /**
     * 商品类目id
     */
    private Long categoryId;

    /**
     * 最低供货价
     */
    private Long supplyPriceMin;

    /**
     * 最高供货价
     */
    private Long supplyPriceMax;

    /**
     * 已上架的最低供货价
     */
    private Long shelfSupplyPriceMin;

    /**
     * 已上架的最高供货价
     */
    private Long shelfSupplyPriceMax;

    /**
     * 最低划线价
     */
    private Long facePriceMin;

    /**
     * 最高划线价
     */
    private Long facePriceMax;

    /**
     * 最低成本价
     */
    private Long costPriceMin;

    /**
     * 最高成本价
     */
    private Long costPriceMax;

    /**
     * 最新一次审核单的状态(-1:未提交,0:待审核,1:已取消,50:审核通过,99:审核拒绝)
     */
    private Integer lastAuditStatus;

    /**
     * 上架状态(0:未上架/仓库中,1:已上架/供货中,3:部分上架)
     *
     * @see ShelfStatusEnum
     */
    private Integer shelfStatus;

    /**
     * 保存时设置的上架状态(0-未上架/仓库中,1-已上架/供货中)
     */
    private Integer shelfSwitch;

    /**
     * 是否可用
     */
    private Integer isUsable;


    /**
     * 商品来源类型
     *
     * @see SourceTypeEnum
     */
    private Integer sourceType;
    /**
     * 上架类型
     *
     * @see ShelfTypeEnum
     */
    private Integer shelfType;
    /**
     * 8 位开关
     *
     * @see ExchangeSwitchEnum
     */
    private Integer exchangeSwitch;
}
