package cn.com.duiba.cloud.channel.center.api.open;


import java.io.Serializable;
import java.util.List;

/**
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2021/12/4 12:05
 */
public interface SkuResolver<R extends Serializable> {

    /**
     * 解析多节点SKU
     * <p>
     * 树转列表
     * 红->大、小
     * 黄->大、小
     * 转为
     * 红、大
     * 红、小
     * 黄、大
     * 黄、小
     */
    List<List<SkuAttributeNode<R>>> resolveNodes(List<SkuAttributeNode<R>> nodes);

    /**
     * 将sku解析成树型结构
     * <p>
     * 列表转树
     * 红、大
     * 红、小
     * 黄、大
     * 黄、小
     * 转为
     * 红->大、小
     * 黄->大、小
     */
    List<SkuAttributeNode<R>> reverseNodes(List<List<SkuAttributeNode<R>>> resolveNodes);


    /**
     * 解析监听器
     *
     * @param <I> 输入类型
     * @param <O> 输出类型
     */
    interface ResolverListener<I, O> {
        void apply(I input, O output);
    }
}
