package cn.com.duiba.cloud.channel.center.api.param.sale;

import cn.com.duiba.cloud.channel.center.api.constant.sale.ShelfStatusEnum;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.ObjectUtil;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;

/**
 * 供应商分页查询spu请求参数
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2022/1/4 3:23 下午
 * @since 0.0.1
 **/
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
public class SupplierPageSpuParam extends PageSpuParam {
    private static final String APP_ID = "appId";
    private static final String BEGIN_TIME = "beginTime";
    private static final String END_TIME = "endTime";
    private static final long serialVersionUID = 5626260601419137877L;

    /**
     * spuId
     */
    private Long spuId;

    /**
     * 供应商的应用id
     */
    @NotNull(message = "应用id不能为空")
    private Long appId;

    /**
     * 商品类型
     */
    private Integer spuType;

    /**
     * 类目id
     */
    private Long categoryId;

    /**
     * 商品名称
     */
    private String spuName;

    /**
     * 上架状态(0:未上架/仓库中,1:已上架/供货中,3:部分上架)
     *
     * @see ShelfStatusEnum
     */
    private Integer shelfStatus;

    /**
     * 保存时设置的上架状态(0-未上架/仓库中,1-已上架/供货中)
     */
    private Integer shelfSwitch;

    /**
     * 最新一次审核单的状态(-1:未提交,0:待审核,1:已取消,50:审核通过,99:审核拒绝)
     */
    private Integer lastAuditStatus;

    /**
     * 创建开始时间
     */
    private Date beginTime;

    /**
     * 创建结束时间
     */
    private Date endTime;

    /**
     * 如果appId和时间条件存在，同时其余条件不存在，强制走联合索引<br>
     * 注意，此写法目前是固定查询字段，如果业务上有新增查询字段，下面代码需要改动，fieldList需要append上新查询字段
     *
     * @return true/false
     */
    public Boolean forceIndex() {
        boolean beginTimeFlag = false;
        boolean endTimeFlag = false;
        ArrayList<String> fieldList = ListUtil.toList("spuType", "spuName", "shelfStatus", "lastAuditStatus", "beginTime", "endTime");
        try {
            for (String name : fieldList) {
                Field field = this.getClass().getDeclaredField(name);
                field.setAccessible(true);
                Object o = field.get(this);
                if (ObjectUtil.isEmpty(o)) {
                    if (name.equals(BEGIN_TIME) || name.equals(END_TIME)) {
                        return false;
                    }
                } else {
                    if (!name.equals(BEGIN_TIME) && !name.equals(END_TIME)) {
                        return false;
                    } else if (name.equals(BEGIN_TIME)) {
                        beginTimeFlag = true;
                    } else {
                        endTimeFlag = true;
                    }
                }
            }
            return beginTimeFlag && endTimeFlag;
        } catch (Exception e) {
            return false;
        }
        /*boolean beginTimeFlag = false;
        boolean endTimeFlag = false;
        List<String> ignoreField = ListUtil.toList("APP_ID", "BEGIN_TIME", "END_TIME", "serialVersionUID",
                "isSearchCount", "$jacocoData");
        Field[] fields = ClassUtil.getDeclaredFields(this.getClass());
        try {
            for (Field field : fields) {
                field.setAccessible(true);
                String name = field.getName();
                if (ignoreField.contains(name)) {
                    continue;
                }
                Object o = field.get(this);
                if (ObjectUtil.isEmpty(o)) {
                    if (name.equals(BEGIN_TIME) || name.equals(END_TIME)) {
                        return false;
                    }
                } else {
                    if (!name.equals(APP_ID) && !name.equals(BEGIN_TIME) && !name.equals(END_TIME)) {
                        return false;
                    } else if (name.equals(BEGIN_TIME)) {
                        beginTimeFlag = true;
                    } else if (name.equals(END_TIME)) {
                        endTimeFlag = true;
                    }
                }
            }
            return beginTimeFlag && endTimeFlag;
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }*/
    }
}