package cn.com.duiba.cloud.channel.center.api.param.sale;

import cn.com.duiba.cloud.channel.center.api.constant.sale.ShelfStatusEnum;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import java.util.Date;
import java.util.List;

/**
 * 分页查询spu列表请求参数
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2022/1/4 3:23 下午
 * @since 0.0.1
 **/
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
public class TenantPageSpuParam extends PageSpuParam {
    private static final long serialVersionUID = 5626260601419137877L;

    /**
     * spuId
     */
    private Long spuId;

    /**
     * 租户的应用id
     */
    @NotNull(message = "应用id不能为空")
    private Long appId;

    /**
     * 商品类型
     */
    private Integer spuType;

    /**
     * 类目id
     */
    private Long categoryId;

    /**
     * 商品名称
     */
    private String spuName;

    /**
     * 是否可用
     */
    private Integer isUsable;

    /**
     * 商品来源应用id
     */
    private List<Long> sourceAppIdList;

    /**
     * 上架状态(0:未上架/仓库中,1:已上架/供货中,3:部分上架)
     *
     * @see ShelfStatusEnum
     */
    private List<Integer> shelfStatusList;

    /**
     * 创建开始时间
     */
    private Date beginTime;

    /**
     * 创建结束时间
     */
    private Date endTime;

    /**
     * 供应商名称、编码
     */
    private String supplierName;
    private String supplierCode;

    /**
     * 商品编码
     */
    private String merchantCoding;
}