package cn.com.duiba.cloud.duiba.consumer.service.api.remoteservice.dto.user.label;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * 用户标签分组表
 * @author kjj mybatis generator 
 * @date 2022-05-09
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class UserLabelGroupDto implements Serializable {
     
    private static final long serialVersionUID = 16520807091301427L;

    /**
     * 主键id
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 0未删除
     */
    private Byte isDeleted;

    /**
     * 标签分组父级id
     */
    private Long parentId;

    /**
     * 标签分组名
     */
    private String labelGroupName;

    /**
     * 平铺分组层级id 逗号隔开   0,1,2,3,4,5
     */
    private String tileLevel;

    /**
     * 最后1级id集合 逗号隔开 3,5
     */
    private String lastLevels;
}