package cn.com.duiba.cloud.duiba.consumer.service.api.remoteservice.enums;

import lombok.Getter;

/**
 * 积分账户类型
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2022/05/05 10:12 上午
 **/
@Getter
public enum CreditAccountTypeEnum {
    /**
     * 积分账户类型
     */
    BALANCE(1, "余额"),
    ;


    private Integer value;

    private String desc;

    CreditAccountTypeEnum(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static String getDesc(int value) {
        for (CreditAccountTypeEnum item : CreditAccountTypeEnum.values()) {
            if (item.value == value) {
                return item.desc;
            }
        }
        return "";
    }

    public static CreditAccountTypeEnum valueOf(Integer value) {
        for (CreditAccountTypeEnum param : values()) {
            if (param.getValue().equals(value)) {
                return param;
            }
        }
        return null;
    }

    public byte getByteValue() {
        return value.byteValue();
    }
}
