package cn.com.duiba.cloud.duiba.consumer.service.api.remoteservice.param;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * PartnerUserId 查Consumer
 * @author huangguosheng@duiba.com.cn
 * @date 2022/3/30 7:33 下午
 **/
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class ConsumerByPartnerUserIdParam implements Serializable {
    private static final long serialVersionUID = -6610833415357512195L;

    /**
     * appId
     */
    @NotNull(message = "appId不能为空")
    private Long appId;

    /**
     * 开发者端用户ID
     */
    @NotNull(message = "partnerUserId不能为空")
    private String partnerUserId;

    /**
     * 是否需要拓展信息，default false
     */
    private Boolean needExtra;
}
