package cn.com.duiba.cloud.duiba.consumer.service.api.remoteservice.dto;

import cn.com.duiba.cloud.duiba.consumer.service.api.remoteservice.constant.ConsumerConstant;
import com.alibaba.fastjson.JSON;
import lombok.Data;
import lombok.experimental.FieldNameConstants;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author huangguosheng@duiba.com.cn
 * @date 2022/3/28 3:05 下午
 **/
@Data
@FieldNameConstants
public class ConsumerDTO implements Serializable {
    private static final long serialVersionUID = 6488302123643921534L;

    /**
     * 唯一编号，系统生成
     */
    private Long cid;

    /**
     * 应用id
     */
    private String appId;

    /**
     * 积分余额
     */
    private Long credits;

    /**
     * 总消耗积分
     */
    private Long totalExpend;

    /**
     * 总收入积分
     */
    private Long totalIncome;
    /**
     * 开发者端用户ID
     */
    private String partnerUserId;

    /**
     * VIP等级
     */
    private String vipGroup;

    /**
     * 昵称
     */
    private String nickname;

    /**
     * 头像
     */
    private String avatar;

    /**
     * 是否新用户
     */
    private Boolean newUser;

    /**
     * 是否关注公众号
     */
    private Boolean followWx;

    /**
     * 冻结状态
     */
    private Integer freezeStatus;
    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 标签名称列表
     */
    private List<String> tagNameList;

    /**
     * 标签id列表
     */
    private List<Long> tagIdList;

    private ConsumerExtraDTO consumerExtra;

    /**
     * 获取用户在某个vip分组下的等级列表
     * @param type
     * @return
     */
    public List<String> getVipLevelsByType(String type) {
        if (StringUtils.isBlank(vipGroup)) {
            return Collections.emptyList();
        }
        Map<String, String> map = new HashMap<>();
        map = JSON.parseObject(vipGroup, map.getClass());
        if (MapUtils.isEmpty(map)) {
            return Collections.emptyList();
        }
        String vipLevels;
        if (StringUtils.isNotBlank(type)) {
            vipLevels = map.get(type);
        }else {
            List<String> keys = new ArrayList<>(map.keySet());
            vipLevels = map.get(keys.get(0));
        }
        if(StringUtils.isBlank(vipLevels)){
            return Collections.emptyList();
        }
        return Arrays.asList(StringUtils.split(vipLevels, ","));
    }

    public Long getLongAppId() {
        return StringUtils.isNotBlank(appId) ? Long.parseLong(appId) : null;
    }

    public boolean isLogin() {
        if (cid != null && !ConsumerConstant.NOT_LOGIN_CID.equals(cid)) {
            return true;
        }
        return false;
    }
}
