package cn.com.duiba.cloud.duiba.consumer.service.api.remoteservice.param;

import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author huangguosheng@duiba.com.cn
 * @date 2022/3/28 3:20 下午
 **/
@Data
public class ConsumerUpdateParam implements Serializable {
    private static final long serialVersionUID = 4739603176955722844L;

    /**
     * 唯一编号，系统生成
     */
    @NotNull(message = "cid不能为空")
    private Long cid;

    /**
     * 应用id
     */
    private String appId;

    /**
     * 积分
     */
    private Long credits;

    /**
     * 开发者端用户ID
     */
    private String partnerUserId;

    /**
     * VIP等级
     */
    private String vipGroup;


    /**
     * 昵称
     */
    private String nickname;

    /**
     * 头像
     */
    private String avatar;

    /**
     * 是否新用户
     */
    private Boolean newUser;

    /**
     * 冻结状态
     */
    private Integer freezeStatus;
    /**
     * 是否关注公众号
     */
    private Boolean followWx;

    /**
     * 用户拓展信息
     */
    private ConsumerExtraUpdateParam consumerExtraUpdateParam;
}
