package cn.com.duiba.cloud.duiba.consumer.service.api.remoteservice.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.duiba.consumer.service.api.remoteservice.dto.CreditAccountFlowDTO;
import cn.com.duiba.cloud.duiba.consumer.service.api.remoteservice.param.CreditAccountFlowQueryParam;
import cn.com.duiba.cloud.duiba.consumer.service.api.remoteservice.param.CreditOptParam;
import cn.com.duiba.wolf.entity.PageResponse;

/**
 * 积分账户操作
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2022/5/5 3:27 下午
 **/
@AdvancedFeignClient
public interface RemoteCreditAccountService {

    /**
     * 获取账户积分
     *
     * @param cid
     * @return
     */
    Long getCreditBalance(Long cid);

    /**
     * 操作积分-托管积分操作专用
     *
     * @param param
     * @return
     * @throws BizException
     */
    Boolean optCredit(CreditOptParam param) throws BizException;

    /**
     * 分页查询积分流水
     *
     * @param param
     * @return
     */
    PageResponse<CreditAccountFlowDTO> queryFlowForPage(CreditAccountFlowQueryParam param);
}
