package cn.com.duiba.cloud.duiba.consumer.service.api.remoteservice.constant;

import cn.com.duiba.cloud.duiba.consumer.service.api.remoteservice.enums.RedisKeySpace;

/**
 * @author zhengjianhao
 * @date 2022/6/14
 * @description 用户等级成长值
 */
public class ConsumerVipGradeConstant {

	/**
	 * key-用户更新等级成长值锁的key
	 * 注：用户更新等级成长值需要加锁，而由于触发的场景比较多，所以将key放在service这里
	 */
	public static String getUpdateVipGradeKey(Long cId){
		return RedisKeySpace.K01.join(cId);
	}

	/**
	 * key-用户初始化等级成长值锁的key
	 */
	public static String getInitVipGradeKey(Long cId) {
		return RedisKeySpace.K02.join(cId);
	}

}
