package cn.com.duiba.cloud.duiba.consumer.service.api.remoteservice.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author zhengjianhao
 * @date 2022/6/13
 * @description
 */
@Data
public class ConsumerGrowthValueFlowDTO implements Serializable {

	/**
	 * 主键id
	 */
	private Long id;

	/**
	 * 用户id
	 */
	private Long cid;

	/**
	 * 商城应用id
	 */
	private Long appId;

	/**
	 * 等级更新时间
	 */
	private Date changeTime;

	/**
	 * 变更来源：1，接口；2，手动变更
	 *
	 * @see cn.com.duiba.cloud.duiba.consumer.service.api.remoteservice.enums.GrowthValueChangeTypeEnum
	 */
	private Integer changeType;

	/**
	 * 明细说明
	 */
	private String detail;

	/**
	 * 变更前成长值
	 */
	private Long oldGrowthValue;

	/**
	 * 变更的成长值
	 */
	private Long changeGrowthValue;

	/**
	 * 关联业务id
	 */
	private String bizId;

	/**
	 * 额外数据
	 */
	private String ext;

	/**
	 * 创建时间
	 */
	private Date gmtCreate;

	/**
	 * 修改时间
	 */
	private Date gmtModified;

}

