package cn.com.duiba.cloud.duiba.consumer.service.api.remoteservice.dto.user.label;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * Created by hong
 * time 2022/5/18.
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class GruopLabelDto implements Serializable {

    private static final long serialVersionUID = -5607171649201009043L;

    /**
     * id
     */
    private String id;

    /**
     * 名称
     */
    private String name;

    /**
     * 标签名
     */
    private String labelName;

    /**
     * 标签分组名
     */
    private String labelGroupName;

    /**
     * 标签分组id
     */
    private Long labelGroupid;

    /**
     * 标签id
     */
    private Long labelId;

    /**
     * 标签分组父级id
     */
    private Long parentId;

    /**
     * 标签数量
     */
    private Integer labelCount;

    /**
     * 是否存在标签
     */
    private Boolean isThereLabel;

    /**
     * 平铺分组层级id 逗号隔开   0,1,2,3,4,5
     */
    private String tileLevel;

    /**
     * 最后1级id集合 逗号隔开 3,5
     */
    private String lastLevels;

    /**
     * 子列表
     */
    private List<GruopLabelDto> list;
}
