package cn.com.duiba.cloud.duiba.consumer.service.api.remoteservice.enums;

import lombok.Getter;

/**
 * 积分变动类型
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2022/05/05 10:12 上午
 **/
@Getter
public enum CreditChangeTypeEnum {
    /**
     * 积分变动类型
     */
    API(1, "接口调用"),
    ARTIFICIAL(2, "手动变更"),
    ACTIVITY(3, "活动"),
    SIGN_IN(4, "签到"),
    RESET(5, "积分同步"),
    TASK(6, "任务"),
    ;


    private Integer value;

    private String desc;

    CreditChangeTypeEnum(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static String getDesc(int value) {
        for (CreditChangeTypeEnum item : CreditChangeTypeEnum.values()) {
            if (item.value == value) {
                return item.desc;
            }
        }
        return "";
    }

    public static CreditChangeTypeEnum valueOf(Integer value) {
        for (CreditChangeTypeEnum param : values()) {
            if (param.getValue().equals(value)) {
                return param;
            }
        }
        return null;
    }

    public byte getByteValue() {
        return value.byteValue();
    }
}
