package cn.com.duiba.cloud.duiba.consumer.service.api.remoteservice.enums;

import lombok.Getter;

/**
 * 错误码枚举
 *
 * @author zouwx
 * @date 2022/05/19
 */
@Getter
public enum ErrorCodeEnum {


    /**
     * 冻结状态枚举
     */
    OPT_IDEMPOTENT(180101, "重复操作"),
    ;


    private Integer value;

    private String desc;

    ErrorCodeEnum(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static String getDesc(int value) {
        for (ErrorCodeEnum item : ErrorCodeEnum.values()) {
            if (item.value == value) {
                return item.desc;
            }
        }
        return "";
    }

    public static ErrorCodeEnum valueOf(Integer value) {
        for (ErrorCodeEnum param : values()) {
            if (param.getValue().equals(value)) {
                return param;
            }
        }
        return null;
    }

    public byte getByteValue() {
        return value.byteValue();
    }
}
