package cn.com.duiba.cloud.duiba.consumer.service.api.remoteservice.enums;

import lombok.Getter;

/**
 * @author: 郑建豪
 * @date: 2022/6/14 21:34
 * @description: 成长值变更类型
 */
@Getter
public enum GrowthValueChangeTypeEnum {
    /**
     * 成长值变动类型
     */
    API(1, "外部接口调用"),
    ARTIFICIAL(2, "手动变更"),
    ACTIVITY(3, "活动"),
    SIGN_IN(4, "签到"),
    AUTO_RELEGATION(5, "过期自动降级"),
    TASK(6, "任务"),
    ;


    private int type;

    private String desc;

    GrowthValueChangeTypeEnum(int type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static String getDesc(int type) {
        for (GrowthValueChangeTypeEnum item : GrowthValueChangeTypeEnum.values()) {
            if (item.getType() == type) {
                return item.desc;
            }
        }
        return "";
    }

    public static GrowthValueChangeTypeEnum valueOf(int type) {
        for (GrowthValueChangeTypeEnum param : values()) {
            if (param.getType() == type) {
                return param;
            }
        }
        return null;
    }
}
