package cn.com.duiba.cloud.duiba.consumer.service.api.remoteservice.enums;

import org.apache.commons.lang3.StringUtils;

@SuppressWarnings("AlibabaEnumConstantsMustHaveComment")
public enum RedisKeySpace {

    /**
     * key-用户更新等级成长值锁的key
     * 注：用户更新等级成长值需要加锁，而由于触发的场景比较多，所以将key放在service这里
     */
    K01("用户等级更新锁"),
    K02("用户初始化成长值记录锁"),
    ;


    /**
     * 应用名称
     */
    private static final String SPACE = "duiba-consumer-service";

    private final String desc;

    RedisKeySpace(String description) {
        this.desc = description;
    }

    public String getDesc() {
        return desc;
    }

    public String join(Object... strs) {
        return toString().concat(StringUtils.join(strs, "_"));
    }

    /**
     * 拼接key前置
     */
    @Override
    public String toString() {
        return SPACE + "_" + super.toString() + "_";
    }

}
