package cn.com.duiba.cloud.duiba.consumer.service.api.remoteservice.param;

import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;

/**
 * 微信拓展信息更新
 * @author huangguosheng@duiba.com.cn
 * @date 2022/3/28 3:20 下午
 **/
@Data
public class ConsumerExtraUpdateParam implements Serializable {
    private static final long serialVersionUID = -2504913796062350865L;
    /**
     * cid
     */
    @NotNull(message = "cid不能为空")
    private Long cid;

    /**
     * 手机号
     */
    private String phone;

    /**
     * 阿里账号
     */
    private String alipay;

    /**
     * 真实姓名
     */
    private String realname;

    /**
     * qq
     */
    private String qq;

    /**
     * 性别：1、男，2、女
     */
    private Integer sex;

    /**
     * 生日
     */
    private Date birthday;

    /**
     * 省编码
     */
    private String provinceCode;

    /**
     * 市编码
     */
    private String cityCode;

    /**
     * 区编码
     */
    private String districtsCode;

    /**
     * 省名称
     */
    private String provinceName;

    /**
     * 市名称
     */
    private String cityName;

    /**
     * 区名称
     */
    private String districtsName;

    /**
     * json字段(扩展字段)
     */
    private String extra;
}
