package cn.com.duiba.cloud.duiba.consumer.service.api.remoteservice.param;

import cn.com.duiba.wolf.entity.PageRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * @author: 郑建豪
 * @date: 2022/6/13 11:42
 * @description: 用户会员等级变更流水分页查询入参
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class ConsumerGrowthValueFlowQueryParam extends PageRequest {

    /**
     * cid
     */
    @NotNull(message = "cid不能为空")
    private Long cid;

    /**
     * 变更来源：1，接口；2，手动变更
     *
     * @see cn.com.duiba.cloud.duiba.consumer.service.api.remoteservice.enums.GrowthValueChangeTypeEnum
     */
    private Integer changeType;

    /**
     * 时间区间-开始时间
     */
    private Date startDate;

    /**
     * 时间区间-结束时间
     */
    private Date endDate;

}
