package cn.com.duiba.cloud.duiba.consumer.service.api.remoteservice.param;

import cn.com.duiba.wolf.entity.PageRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotNull;
import java.util.Date;
import java.util.List;

/**
 * 用户查询
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2022/3/28 12:05 下午
 **/
@Data
@EqualsAndHashCode(callSuper = true)
public class ConsumerQueryParam extends PageRequest {

    private static final long serialVersionUID = 7682908893353455747L;

    public static final String DESC = "DESC";
    public static final String ASC = "ASC";
    /**
     * cid
     */
    private Long cid;

    /**
     * cid列表,与cid或关系，优先cid
     */
    private List<Long> cidList;

    /**
     * 应用id
     */
    @NotNull(message = "appId不能为空")
    private Long appId;

    /**
     * 开发者端用户ID
     */
    private String partnerUserId;

    /**
     * uid列表
     */
    private List<String> uidList;

    /**
     * 昵称
     */
    private String nickname;

    /**
     * 是否新用户
     */
    private Boolean newUser;

    /**
     * 是否关注公众号
     */
    private Boolean followWx;
    /**
     * 性别
     */
    private Integer sex;

    /**
     * 电话
     */
    private String phone;

    /**
     * 冻结状态
     */
    private Integer freezeStatus;

    /**
     * 生日开始日期
     */
    private Date birthdayStartDate;

    /**
     * 生日结束日期
     */
    private Date birthdayEndDate;
    /**
     * 创建开始日期
     */
    private Date gmtCreateStartDate;

    /**
     * 创建结束日期
     */
    private Date gmtCreateEndDate;
    /**
     * 省编码
     */
    private String provinceCode;

    /**
     * 市编码
     */
    private String cityCode;

    /**
     * 区编码
     */
    private String districtsCode;

    /**
     * 标签id列表
     */
    private List<Long> tagIdList;

    /**
     * VIP等级
     */
    private String vipGroup;

    /**
     * 按下单时间排序
     * DESC 倒叙
     * ASC 正序
     */
    private String gmtCreateTimeSort = DESC;

    /**
     * 是否需要拓展信息
     */
    private Boolean needExtra = false;


}
