package cn.com.duiba.cloud.duiba.consumer.service.api.remoteservice.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.duiba.consumer.service.api.remoteservice.dto.ConsumeMallAppVipGradeDTO;
import cn.com.duiba.cloud.duiba.consumer.service.api.remoteservice.dto.ConsumerGrowthValueDTO;
import cn.com.duiba.cloud.duiba.consumer.service.api.remoteservice.param.ConsumerGrowthValueUpdateParam;

import java.util.List;

/**
 * @author zhengjianhao
 * @date 2022/6/13
 * @description
 */
@AdvancedFeignClient
public interface RemoteConsumerGrowthValueService {

	/**
	 * 根据用户cid查询，如果查不到，会创建记录
	 */
	ConsumerGrowthValueDTO getByCid(Long cid);

	/**
	 * 根据用户uid查询
	 */
	ConsumerGrowthValueDTO getByPartnerUserId(String uid);

	/**
	 * 根据用户id列表查询，最多1000条
	 */
	List<ConsumerGrowthValueDTO> getByCidList(List<Long> cidList);

	/**
	 * 更新
	 */
	void update(ConsumerGrowthValueDTO dto) throws BizException;

	/**
	 * B端-上游定时任务执行-用户等级过期自动降级
	 */
	void doAutoRelegation();

	/**
	 * B端-新增app会员等级，同步用户等级
	 *
	 * @param appId
	 * @param growthValueSectionMin 较低一级的升级规则
	 * @param growthValueSectionMax 较高一级的升级规则
	 */
	void addLevelConf(Long appId, Long growthValueSectionMin, Long growthValueSectionMax);

	/**
	 * B端-编辑app会员等级，同步用户等级
	 */
	void editLevelConf(Long appId, ConsumeMallAppVipGradeDTO newGradeConf, ConsumeMallAppVipGradeDTO oldConf, Integer lowerLevelGrade, Long growthValueSectionMin,
			Long growthValueSectionMax);

	/**
	 * B端-删除app会员等级，同步用户等级
	 */
	void deleteLevelConf(Long appId, Integer grade);

	/**
	 * 减少用户成长值-只有B端有
	 *
	 * @param param
	 * @throws BizException 形同bizId已执行过异常码：180101
	 */
	void decreaseGrowthValue(ConsumerGrowthValueUpdateParam param) throws BizException;

	/**
	 * 增加用户成长值-B端C端都有
	 *
	 * @param param
	 * @throws BizException 形同bizId已执行过异常码：180101
	 */
	void increaseGrowthValue(ConsumerGrowthValueUpdateParam param) throws BizException;
}
