package cn.com.duiba.cloud.duiba.consumer.service.api.remoteservice.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.duiba.consumer.service.api.remoteservice.dto.ConsumerDTO;
import cn.com.duiba.cloud.duiba.consumer.service.api.remoteservice.dto.ConsumerExtraDTO;
import cn.com.duiba.cloud.duiba.consumer.service.api.remoteservice.param.ConsumerAddParam;
import cn.com.duiba.cloud.duiba.consumer.service.api.remoteservice.param.ConsumerByPartnerUserIdParam;
import cn.com.duiba.cloud.duiba.consumer.service.api.remoteservice.param.ConsumerExtraUpdateParam;
import cn.com.duiba.cloud.duiba.consumer.service.api.remoteservice.param.ConsumerQueryParam;
import cn.com.duiba.cloud.duiba.consumer.service.api.remoteservice.param.ConsumerUpdateFreezeParam;
import cn.com.duiba.cloud.duiba.consumer.service.api.remoteservice.param.ConsumerUpdateParam;
import cn.com.duiba.cloud.duiba.consumer.service.api.remoteservice.param.CreditOptParam;
import cn.com.duiba.wolf.entity.PageResponse;

import java.util.List;

/**
 * 用户服务
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2022/3/28 2:29 下午
 **/
@AdvancedFeignClient
public interface RemoteConsumerService {
    /**
     * 查询用户信息
     *
     * @param param
     * @return
     */
    PageResponse<ConsumerDTO> queryForPage(ConsumerQueryParam param);

    /**
     * 添加用户信息
     *
     * @param param
     * @return
     * @throws BizException
     */
    Long addOne(ConsumerAddParam param) throws BizException;

    /**
     * 批量添加用户信息
     *
     * @param paramList 参数列表
     * @return {@link List}<{@link Long}>
     * @throws BizException 业务异常
     */
    List<Long> addBatch(List<ConsumerAddParam> paramList) throws BizException;
    /**
     * 更新用户信息
     *
     * @param param
     * @return
     * @throws BizException
     */
    Boolean updateByCid(ConsumerUpdateParam param) throws BizException;

    /**
     * 批量修改 不支持修改积分和拓展信息
     *
     * @param paramList 参数列表
     * @return int
     * @throws BizException 业务异常
     */
    void updateFreezeStatusByCid(ConsumerUpdateFreezeParam paramList) throws BizException;

    /**
     * 更新拓展信息
     *
     * @param param
     * @return
     */
    Boolean updateExtraByCid(ConsumerExtraUpdateParam param);

    /**
     * 查询用户信息
     *
     * @param cid
     * @return
     */
    ConsumerDTO getDetail(Long cid, Boolean needExtra);

    /**
     * 获取用户积分（外层无需关心托管｜非托管）
     * @param cid
     * @return
     */
    Long getConsumerCredit(Long cid);

    /**
     * 三方userId获取用户信息
     *
     * @param param
     * @return
     */
    ConsumerDTO getByPartnerUserId(ConsumerByPartnerUserIdParam param);

    /**
     * 查询用户拓展信息
     *
     * @param cid
     * @return
     */
    ConsumerExtraDTO getExtraDetail(Long cid);

    /**
     * 查询用户信息 单表没有拓展信息
     *
     * @param cidList cid列表
     * @return {@link List}<{@link ConsumerDTO}>
     */
    List<ConsumerDTO> getConsumerByCidList(List<Long> cidList);
    /**
     * 操作积分-免登积分用
     *
     * @param param
     * @throws BizException
     * 替换为：cn.com.duiba.cloud.duiba.consumer.service.api.remoteservice.remoteservice.RemoteCreditAccountService#optCredit(cn.com.duiba.cloud.duiba.consumer.service.api.remoteservice.param.CreditOptParam)
     */
    Boolean optCredit(CreditOptParam param) throws BizException;

}
