package cn.com.duiba.cloud.duiba.consumer.service.api.remoteservice.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.duiba.consumer.service.api.remoteservice.dto.user.label.GruopLabelDto;
import cn.com.duiba.cloud.duiba.consumer.service.api.remoteservice.dto.user.label.LabelDetailDto;
import cn.com.duiba.cloud.duiba.consumer.service.api.remoteservice.dto.user.label.LabelDto;
import cn.com.duiba.cloud.duiba.consumer.service.api.remoteservice.dto.user.label.LabelGroupDto;
import cn.com.duiba.cloud.duiba.consumer.service.api.remoteservice.dto.user.label.UserLabelDto;
import cn.com.duiba.cloud.duiba.consumer.service.api.remoteservice.param.user.label.AddLabelGroupParam;
import cn.com.duiba.cloud.duiba.consumer.service.api.remoteservice.param.user.label.AddLabelParam;
import cn.com.duiba.cloud.duiba.consumer.service.api.remoteservice.param.user.label.BatchInsertUserLabelsParam;
import cn.com.duiba.cloud.duiba.consumer.service.api.remoteservice.param.user.label.BatchUpdateGroupParam;
import cn.com.duiba.cloud.duiba.consumer.service.api.remoteservice.param.user.label.DelLabelGroupParam;
import cn.com.duiba.cloud.duiba.consumer.service.api.remoteservice.param.user.label.DelLabelParam;
import cn.com.duiba.cloud.duiba.consumer.service.api.remoteservice.param.user.label.LabelQueryPageParam;
import cn.com.duiba.cloud.duiba.consumer.service.api.remoteservice.param.user.label.LabelSearchParam;
import cn.com.duiba.cloud.duiba.consumer.service.api.remoteservice.param.user.label.UpdateLabelGroupParam;
import cn.com.duiba.cloud.duiba.consumer.service.api.remoteservice.param.user.label.UpdateLabelParam;
import cn.com.duiba.cloud.duiba.consumer.service.api.remoteservice.param.user.label.UserLabelGroupSearchParam;
import cn.com.duiba.wolf.entity.PageResponse;

import java.util.List;
import java.util.Map;

/**
 * Created by hong
 * time 2022/5/9.
 */
@AdvancedFeignClient
public interface RemoteUserLabelService {
    /**
     * 标签组列表
     */
    List<LabelGroupDto> groupList(UserLabelGroupSearchParam param);

    /**
     * 标签列表分页查询
     *
     * @param param
     */
    PageResponse<LabelDto> list(LabelQueryPageParam param);

    /**
     * 查询标签详情
     *
     * @param id id
     */
    LabelDetailDto detail(Long id);
    /**
     * 新增标签分组
     *
     * @param param
     */
    Long addGroup( AddLabelGroupParam param) throws BizException;

    /**
     * 修改标签分组
     *
     * @param param
     */
    Boolean updateGroup( UpdateLabelGroupParam param);

    /**
     * 新增标签
     *
     * @param param
     */
    Boolean addLabel( AddLabelParam param) throws BizException;

    /**
     * 修改标签
     *
     * @param param
     */
    Boolean updateLabel( UpdateLabelParam param) throws BizException;

    /**
     * 删除标签（批量）
     *
     * @param param
     */
    Boolean batchDelLabel( DelLabelParam param);

    /**
     * 删除标签组
     *
     * @param param
     */
    Boolean delGroup( DelLabelGroupParam param);

    /**
     * 删除标签组
     *
     * @param param
     */
    Boolean batchUpdateGroup( BatchUpdateGroupParam param);

    /**
     * 根据主键查询
     * @param cids userID集合
     * @return 用户标签关系
     */
    Map<Long,List<LabelDto>> selectBycids(List<Long> cids);

    /**
     * 根据标签名集合查询标签
     * @param names 标签名集合
     */
    List<UserLabelDto> selectByNames(List<String> names);

    /**
     * 根据用户批量插入用户标签关系
     */
    Integer batchInsertUserLabels(List<BatchInsertUserLabelsParam> params);

    /**
     * 标签搜索
     * @param name 标签或者标签组名称
     */
    List<GruopLabelDto> search(LabelSearchParam param);
}
